/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationLoader;
import lib.toma.animations.api.IKeyframe;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.engine.frame.KeyframeProvider;
import lib.toma.animations.engine.serialization.KeyframeProviderSerializer;
import lib.toma.animations.engine.serialization.KeyframeSerializer;
import lib.toma.animations.engine.serialization.Vector3dSerializer;
import lib.toma.animations.engine.serialization.Vector3fSerializer;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class AnimationLoader
extends JsonReloadListener
implements IAnimationLoader {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Loader");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeHierarchyAdapter(IKeyframeProvider.class, (Object)new KeyframeProviderSerializer()).registerTypeHierarchyAdapter(IKeyframe.class, (Object)new KeyframeSerializer()).registerTypeAdapter(Vector3d.class, (Object)new Vector3dSerializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fSerializer()).create();
    private final Map<ResourceLocation, IKeyframeProvider> animationDefinitions = new HashMap<ResourceLocation, IKeyframeProvider>();
    private final List<IAnimationLoader.ILoadingFinished> loadListeners = new ArrayList<IAnimationLoader.ILoadingFinished>();
    private final IAnimationLoader.ILoader loader = reader -> (IKeyframeProvider)GSON.fromJson(reader, IKeyframeProvider.class);

    public AnimationLoader() {
        super(GSON, "animation");
    }

    @Override
    public IKeyframeProvider getProvider(ResourceLocation key) {
        return this.animationDefinitions.computeIfAbsent(key, KeyframeProvider::noFrames);
    }

    @Override
    public IAnimationLoader.ILoader getResourceReader() {
        return this.loader;
    }

    @Override
    public String serializeResource(IKeyframeProvider provider) {
        return GSON.toJson((Object)provider, IKeyframeProvider.class).replaceAll("\\s+", "");
    }

    @Override
    public void addLoadingListener(IAnimationLoader.ILoadingFinished listener) {
        this.loadListeners.add(listener);
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, IResourceManager manager, IProfiler profiler) {
        profiler.func_219894_a();
        profiler.func_76320_a("Animation loading");
        Logger log = AnimationEngine.logger;
        log.info(MARKER, "Loading animations");
        this.animationDefinitions.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                IKeyframeProvider provider = (IKeyframeProvider)GSON.fromJson(value, IKeyframeProvider.class);
                this.animationDefinitions.put(key, provider);
            }
            catch (JsonParseException parseException) {
                log.error(MARKER, "Couldn't parse animation file {}: {}", (Object)key, (Object)parseException.getMessage());
            }
            catch (Exception e) {
                log.fatal(MARKER, "Exception ocurred while parsing animation file {}: {}", (Object)key, (Object)e.toString());
            }
        }
        this.notifyListeners(log);
        log.info(MARKER, "Loaded {} animations", (Object)this.animationDefinitions.size());
        profiler.func_76319_b();
        profiler.func_219897_b();
    }

    private void notifyListeners(Logger log) {
        int len = this.loadListeners.size();
        if (len == 0) {
            return;
        }
        log.debug(MARKER, "Sending load notification to {} listeners", (Object)this.loadListeners.size());
        ImmutableMap map = ImmutableMap.copyOf(this.animationDefinitions);
        this.loadListeners.forEach(listener -> listener.onLoaded((Map<ResourceLocation, IKeyframeProvider>)map, this.loader));
        log.debug(MARKER, "All listeners have been notified");
    }
}

